<?php
/**
 * Plugin Name: Lixlog Shipping Method for Woocommerce
 * Plugin URI: https://github.com/Flixlog-Tecnologia/woocommerce-plugin-v2
 * Description: A forma mais eficiente de enviar pedidos.
 * Version: 0.0.2
 * Developer: André Kiffer
 * Developer URI: https://andrekiffer.com.br
 * Text Domain: lixlog-woocommerce-plugin
 * Domain Path: /languages
 * Requires at least: 5.4.0
 * Requires PHP: 7.1
 *
 * WC requires at least: 4.3.0
 * WC tested up to: 4.5.2
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 */

defined( 'ABSPATH' ) || exit;
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {

	function lixlog_shipping_method_init() {
		require_once "src/WC_Lixlog_Shipping_Method.php";
	}
	add_action( 'woocommerce_shipping_init', 'lixlog_shipping_method_init' );

	function add_lixlog_shipping_method( $methods ) {
		$methods['lixlog_shipping_method'] = 'WC_Lixlog_Shipping_Method';
		return $methods;
	}
	add_filter( 'woocommerce_shipping_methods', 'add_lixlog_shipping_method' );

}
